---------------- triggers para auditoria de alteração do status de credito do conveniado ----------------------------
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_CONV_RC_CLI_ALT_STS_CRED]'))

/****** Object:  Trigger [TRG_RC_CLI_CONV_RC_CLI_ALT_STS_CRED]    Script Date: 29/05/2015 09:40:35 ******/
DROP TRIGGER [dbo].[TRG_RC_CLI_CONV_RC_CLI_ALT_STS_CRED]
GO

/****** Object:  Trigger [dbo].[TRG_RC_CLI_CONV_RC_CLI_ALT_STS_CRED]    Script Date: 29/05/2015 09:40:35 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE TRIGGER [dbo].[TRG_RC_CLI_CONV_RC_CLI_ALT_STS_CRED] ON [dbo].[RC_CLI_CONV_RC_CLI] AFTER  UPDATE
AS
BEGIN TRY
	IF UPDATE(STS_CRED) OR UPDATE(FLAG_CONVENIADO_DEMISSAO) OR UPDATE (STS_ATIVO)
	BEGIN
		INSERT INTO RC_CLI_CONV_RC_CLI_AUDITORIA (CD_EMP,CD_CONV,CD_CLI,CD_USU_ALT,STS_CRED,STS_ATIVO,DT_ALT,FLAG_CONVENIADO_DEMISSAO) 
		SELECT       
			A.CD_EMP,
			A.CD_CONV,
			A.CD_CLI,
			ISNULL(C.CD_USU_ALT,C.CD_USU) AS CD_USU_ALT,
			A.STS_CRED,
			A.STS_ATIVO,
			GETDATE() AS DT_ALT,
			A.FLAG_CONVENIADO_DEMISSAO
		FROM       
		INSERTED A INNER JOIN RC_CLI C ON
		A.CD_EMP=C.CD_EMP AND
		A.CD_CLI=C.CD_CLI 
	END
END TRY



BEGIN CATCH
	ROLLBACK TRAN
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH


GO



